"""
<problem>
Problem Link: https://leetcode.com/problems/4sum-ii/

Given four integer arrays nums1, nums2, nums3, and nums4 all of length n, return the number of tuples 
(i, j, k, l) such that:
0 <= i, j, k, l < n
nums1[i] + nums2[j] + nums3[k] + nums4[l] == 0

Example 1:
Input: nums1 = [1,2], nums2 = [-2,-1], nums3 = [-1,2], nums4 = [0,2]
Output: 2
Explanation:
The two tuples are:
1. (0, 0, 0, 1) -> nums1[0] + nums2[0] + nums3[0] + nums4[1] = 1 + (-2) + (-1) + 2 = 0
2. (1, 1, 0, 0) -> nums1[1] + nums2[1] + nums3[0] + nums4[0] = 2 + (-1) + (-1) + 0 = 0

Example 2:
Input: nums1 = [0], nums2 = [0], nums3 = [0], nums4 = [0]
Output: 1

Constraints:
n == nums1.length
n == nums2.length
n == nums3.length
n == nums4.length
1 <= n <= 200
-228 <= nums1[i], nums2[i], nums3[i], nums4[i] <= 228
</problem>
<bug_fixes>
Replace `nums3` with `nums4` on line 11.
</bug_fixes>
<bug_desc>
On line 11, the list nums3 is being iterated over instead of nums4. This seems to be a syntactical mistake as nums4 needs to be iterated over. Replacing nums3 with nums4 will fix the bug.
</bug_desc>
"""
class Solution:
    def fourSumCount(self, nums1: List[int], nums2: List[int], nums3: List[int], nums4: List[int]) -> int:
        cur_sum = {}
        
        for num1 in nums1:
            for num2 in nums2:
                cur_sum[num1+num2] = cur_sum.get(num1+num2, 0) + 1
                
        count = 0         
        for num3 in nums3:
            for num4 in nums3:
                count += cur_sum.get(-num3-num4, 0)
                
        return count
